import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';

import cx from './AmenitiesLayout.scss';

export interface IAbstractAmenitiesProps
    extends IWithClassName,
        IWithDeviceType {}

const AmenitiesLayout: React.FC<IAbstractAmenitiesProps> = ({
    children,
    deviceType,
    className,
}) => (
    <div className={cx(deviceMods('root', deviceType), className)}>
        {children}
    </div>
);

export default AmenitiesLayout;
