import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';
import {IHotelOrRoomAmenity} from 'types/hotels/hotel/IHotel';

import {deviceModDesktop} from 'utilities/stylesUtils';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import MainAmenity from '../MainAmenity/MainAmenity';

import cx from './MainAmenities.scss';

interface IMainAmenitiesProps extends IWithDeviceType {
    mainAmenities?: IHotelOrRoomAmenity[];
    isAllAmenities: boolean;
    isModal?: boolean;
}

const MainAmenities: React.FC<IMainAmenitiesProps> = ({
    mainAmenities,
    deviceType,
    isModal,
}) => {
    if (!mainAmenities || !mainAmenities.length) {
        return null;
    }

    return (
        <div className={cx(deviceModDesktop('mainAmenities', deviceType))}>
            {mainAmenities.map((amenity, index) => (
                <MainAmenity
                    key={amenity.id}
                    className={cx('mainAmenity', {
                        mainAmenity_type_bold: isModal,
                    })}
                    amenity={amenity}
                    {...prepareQaAttributes({
                        current: 'mainAmenity',
                        key: index,
                    })}
                />
            ))}
        </div>
    );
};

export default MainAmenities;
