import {IWithClassName} from 'types/withClassName';
import {
    IHotelOrRoomAmenity,
    MainAmenityIdType,
} from 'types/hotels/hotel/IHotel';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {getIconByAmenityId} from 'projects/hotels/utilities/amenities/getIconByAmenityId';

import Include from 'icons/16/Include';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

export interface IMainAmenitiesProps extends IWithClassName, IWithQaAttributes {
    amenity: IHotelOrRoomAmenity;
}

const MainAmenity: React.FC<IMainAmenitiesProps> = ({
    amenity: {id, name},
    className,
    ...rest
}) => {
    if (Object.values(MainAmenityIdType).includes(id as MainAmenityIdType)) {
        const Icon = getIconByAmenityId(id as MainAmenityIdType);

        return (
            <TextWithIcon
                className={className}
                iconLeft={Icon}
                text={name}
                {...prepareQaAttributes(rest)}
            />
        );
    }

    return (
        <TextWithIcon
            className={className}
            iconLeft={Include}
            text={name}
            {...prepareQaAttributes(rest)}
        />
    );
};

export default MainAmenity;
