import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import SearchIcon from 'icons/16/Search';

import cx from './BaseHeaderSearchInformation.scss';

interface IBaseHeaderSearchInformationProps
    extends IWithClassName,
        IWithDeviceType,
        IWithQaAttributes {
    onClick: () => void;
    direction?: string;
    date?: string;
    guests?: string;
}

const BaseHeaderSearchInformation: React.FC<IBaseHeaderSearchInformationProps> =
    props => {
        const {className, deviceType, direction, date, guests, onClick} = props;

        const {isMobile} = deviceType;

        const rootQa = prepareQaAttributes({
            parent: props,
            current: 'headerSearchInformation',
        });

        return (
            <div
                className={cx(
                    'root',
                    deviceMods('root', deviceType),
                    className,
                )}
                onClick={onClick}
                title={[direction, date, guests].filter(Boolean).join(', ')}
                {...prepareQaAttributes(rootQa)}
            >
                <div className={cx('content')}>
                    {direction && (
                        <div
                            className={cx('direction')}
                            {...prepareQaAttributes({
                                parent: rootQa,
                                current: 'direction',
                            })}
                        >
                            {direction}
                        </div>
                    )}
                    <div className={cx('searchParams')}>
                        {date && (
                            <div
                                className={cx('date')}
                                {...prepareQaAttributes({
                                    parent: rootQa,
                                    current: 'date',
                                })}
                            >
                                {date}
                            </div>
                        )}
                        {guests && isMobile && (
                            <div
                                className={cx('guests')}
                                {...prepareQaAttributes({
                                    parent: rootQa,
                                    current: 'guests',
                                })}
                            >
                                {guests}
                            </div>
                        )}
                    </div>
                </div>
                <div className={cx('iconWrapper')}>
                    <SearchIcon className={cx('icon')} />
                </div>
            </div>
        );
    };

export default BaseHeaderSearchInformation;
