import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IRoomBedGroup} from 'types/hotels/offer/IHotelRoom';

import * as i18nBlock from 'i18n/hotels-HotelPageRooms';

import BedGroup from './components/BedGroup/BedGroup';
import Intersperse from 'components/Intersperse/Intersperse';

import cx from './BedGroups.scss';

export interface IBedGroupsProps extends IWithClassName {
    bedGroups: IRoomBedGroup[];
    bedClassName?: string;
    canViewBedName?: boolean;
    canViewImage?: boolean;
    isSeparatorBlock?: boolean;
}

const BedGroups: FunctionComponent<IBedGroupsProps> = ({
    className,
    bedClassName,
    bedGroups,
    canViewBedName,
    canViewImage,
    isSeparatorBlock,
    children,
}) => {
    return (
        <div className={cx('root', className)}>
            <Intersperse
                separator={
                    isSeparatorBlock ? (
                        <div className={cx('separator')}>
                            {i18nBlock.bedGroupsSeparator()}
                        </div>
                    ) : (
                        <>&nbsp;{i18nBlock.bedGroupsSeparator()} </>
                    )
                }
            >
                {bedGroups.map(bedGroup => {
                    return (
                        <BedGroup
                            key={bedGroup.id}
                            bedClassName={bedClassName}
                            bedGroup={bedGroup}
                            canViewBedName={canViewBedName}
                            canViewImage={canViewImage}
                        />
                    );
                })}
            </Intersperse>
            {children}
        </div>
    );
};

export default BedGroups;
