import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IRoomBedGroup} from 'types/hotels/offer/IHotelRoom';

import Bed from './components/Bed/Bed';
import Intersperse from 'components/Intersperse/Intersperse';

import cx from './BedGroup.scss';

export interface IBedGroupProps extends IWithClassName {
    bedGroup: IRoomBedGroup;
    canViewBedName?: boolean;
    canViewImage?: boolean;
    bedClassName?: string;
}

const BedGroup: FunctionComponent<IBedGroupProps> = ({
    className,
    bedClassName,
    bedGroup,
    canViewBedName,
    canViewImage,
}) => {
    const {configuration} = bedGroup;

    return (
        <div className={cx('root', className)}>
            <Intersperse separator={<div className={cx('separator')}>+</div>}>
                {configuration.map(roomBed => (
                    <Bed
                        className={bedClassName}
                        key={roomBed.id}
                        bed={roomBed}
                        canViewBedName={canViewBedName}
                        canViewImage={canViewImage}
                    />
                ))}
            </Intersperse>
        </div>
    );
};

export default BedGroup;
