import {FunctionComponent} from 'react';

import {TBookOfferBedsGroups} from 'server/api/HotelsBookAPI/types/IBookOffer';
import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import BedIcon from 'icons/16/Bed';

interface IBedsGroups extends IWithClassName, IWithQaAttributes {
    bedsGroups: TBookOfferBedsGroups;
}

const BedsGroups: FunctionComponent<IBedsGroups> = props => {
    const {bedsGroups, className} = props;

    if (bedsGroups.length === 0) {
        return null;
    }

    const [firstBedsGroup] = bedsGroups;
    const {description} = firstBedsGroup;

    return (
        <section className={className} {...prepareQaAttributes(props)}>
            <TextWithIcon iconLeft={BedIcon} text={description} />
        </section>
    );
};

export default BedsGroups;
