import React from 'react';

import Text from 'components/Text/Text';

import cx from './BracketWithTextUnderInterval.scss';

interface IBracketWithTextUnderIntervalProps {
    text: string;
    bracketColor?: 'primary' | 'badge-secondary';
}

const BracketWithTextUnderInterval: React.FC<IBracketWithTextUnderIntervalProps> =
    ({text, bracketColor = 'primary'}) => {
        return (
            <div className={cx('root', `root_bracketColor_${bracketColor}`)}>
                <div className={cx('bracket')}>
                    <div className={cx('leftBracketArc')} />
                    <div className={cx('line')} />
                    <div className={cx('rightBracketArc')} />
                </div>

                <div className={cx('dash')} />

                <Text size="s">{text}</Text>
            </div>
        );
    };

export default BracketWithTextUnderInterval;
