import React, {useCallback, useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {TBookLegalInfo} from 'server/api/HotelsBookAPI/types/IBookOffer';
import {isNotUndefined} from 'types/utilities';

import preparePartner from './utilities/preparePartner';

import * as i18nBlock from 'i18n/hotels-BookLicenseAgreement';

import LinkButton from 'components/LinkButton/LinkButton';
import PartnersRequisites from 'components/PartnersRequisites/PartnersRequisites';
import LicenseAgreementsLinks from './components/LicenseAgreementsLinks/LicenseAgreementsLinks';

import cx from './BookLicenseAgreement.scss';

interface IBookLicenseAgreementProps extends IWithClassName {
    isBookStep?: boolean;
    legalInfo: TBookLegalInfo;
}

const BookLicenseAgreement: React.FC<IBookLicenseAgreementProps> = props => {
    const {className, isBookStep = true, legalInfo = []} = props;

    const partners = useMemo(
        () =>
            legalInfo.map(info => preparePartner(info)).filter(isNotUndefined),
        [legalInfo],
    );
    const renderTextWithLink = useCallback((linkProps): React.ReactNode => {
        return (
            <span className={cx('textBlock')}>
                {i18nBlock.hotelInfoSource()}&nbsp;
                <LinkButton theme="normal" {...linkProps}>
                    {i18nBlock.partnersInfoLink()}
                </LinkButton>
            </span>
        );
    }, []);

    return (
        <div className={className}>
            {isBookStep && (
                <>
                    <LicenseAgreementsLinks className={cx('textBlock')} />
                    <div className={cx('textBlock')}>
                        {i18nBlock.prepayChargeTitle()}
                    </div>
                </>
            )}
            <PartnersRequisites
                modalTitle={i18nBlock.partnersRequisites()}
                modalSubTitle={i18nBlock.partnersReferenceInformation()}
                partners={partners}
                renderTextWithLink={renderTextWithLink}
            />
        </div>
    );
};

export default React.memo(BookLicenseAgreement);
