import React, {MouseEvent} from 'react';

import licenseAgreementsLinks from './constants/licenseAgreementsLinks';
import {EAppActions} from 'constants/platforms/TPlatforms';

import {IWithClassName} from 'types/withClassName';

import * as i18nBlock from 'i18n/hotels-BookLicenseAgreement';

import Link from 'components/Link/Link';
import Intersperse from 'components/Intersperse/Intersperse';

import {useCoordinator} from 'contexts/PlatformContext';

interface ILicenseAgreementsLinksProps extends IWithClassName {}

const LicenseAgreementsLinks: React.FC<ILicenseAgreementsLinksProps> =
    props => {
        const {className} = props;

        const coordinator = useCoordinator();

        return (
            <div className={className}>
                {i18nBlock.agreementLabel()}&nbsp;
                <Intersperse separator=", ">
                    {licenseAgreementsLinks.map(({label, link}, index) => (
                        <span key={index}>
                            <Link
                                url={link}
                                theme="normal"
                                target="_blank"
                                text={label}
                                onClick={(e: MouseEvent): void => {
                                    const processed = coordinator.doAction(
                                        EAppActions.NAVIGATE_TO_EXTERNAL_URL,
                                        link,
                                    );

                                    if (processed) {
                                        e.preventDefault();
                                    }
                                }}
                            />
                        </span>
                    ))}
                </Intersperse>
                .
            </div>
        );
    };

export default LicenseAgreementsLinks;
