import {IBookLegalInfo} from 'server/api/HotelsBookAPI/types/IBookOffer';
import IPartnerRequisites from 'components/PartnersRequisites/types/IPartnerRequisites';

import * as i18nBlock from 'i18n/hotels-BookLicenseAgreement';

export default function preparePartner(
    legalInfo: IBookLegalInfo,
): IPartnerRequisites | undefined {
    const fields = [
        {
            name: i18nBlock.partnersOgrn(),
            value: legalInfo.ogrn,
        },
        {
            name: i18nBlock.partnersRegistryNumber(),
            value: legalInfo.registryNumber,
        },
        {
            name: i18nBlock.partnersActualAddress(),
            value: legalInfo.actualAddress,
        },
        {
            name: i18nBlock.partnersLegalAddress(),
            value: legalInfo.legalAddress,
        },
        {
            name: i18nBlock.partnersWorkingHours(),
            value: legalInfo.workingHours,
        },
    ].filter(f => f.value);

    if (!fields.length) {
        return undefined;
    }

    return {
        title: legalInfo.name,
        fields,
    };
}
