import {FunctionComponent} from 'react';

import {IWithClassName} from 'src/types/withClassName';
import {IBookOfferMeal} from 'server/api/HotelsBookAPI/types/IBookOffer';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import FoodIcon from 'icons/16/Food';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

import cx from './BookMealInfo.scss';

interface IBookMealInfoProps extends IWithClassName, IWithQaAttributes {
    mealInfo: IBookOfferMeal;
    isSuccess?: boolean;
}

const BookMealInfo: FunctionComponent<IBookMealInfoProps> = props => {
    const {className, mealInfo, isSuccess = false} = props;

    return 'name' in mealInfo ? (
        <TextWithIcon
            className={cx(className, {success: isSuccess})}
            iconLeft={FoodIcon}
            text={mealInfo?.name}
            {...prepareQaAttributes(props)}
        />
    ) : null;
};

export default BookMealInfo;
