import React, {useState} from 'react';

import {IWhiteLabelPoints} from 'server/api/OrdersAPI/types/TOrdersGetOrderHappyPageApiResponse';
import {IWithClassName} from 'types/withClassName';

import {useWhiteLabelConfig} from 'utilities/hooks/useWhiteLabelConfig';
import {getWhiteLabelBadgeLogoByPointsType} from 'components/WhiteLabelLoyaltyBadge/utilities/getWhiteLabelBadgeLogo';

import * as i18nBlock from 'i18n/white-label-common';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import TriggerDetailsButton from 'components/TriggerDetailsButton/TriggerDetailsButton';
import {EMessageBoxPopupTheme} from 'components/MessageBoxPopup/MessageBoxPopup';
import Heading from 'components/Heading/Heading';
import Box from 'components/Box/Box';
import Link from 'components/Link/Link';

import ScopeContext from 'contexts/ScopeContext';

import cx from './WhiteLabelPartnerBonusInfo.scss';

interface IWhiteLabelPartnerBonusInfoProps extends IWithClassName {
    points: IWhiteLabelPoints;
}

const WhiteLabelPartnerBonusInfo: React.FC<IWhiteLabelPartnerBonusInfoProps> =
    ({className, points}) => {
        const [ref, setRef] = useState(undefined);
        const {config: whiteLabelConfig} = useWhiteLabelConfig();
        const LoyaltyIcon = getWhiteLabelBadgeLogoByPointsType(
            points.pointsType,
        );
        const pointsTooltip = whiteLabelConfig?.pointsTooltip;

        return (
            <ScopeContext.Provider value={ref || undefined}>
                <Flex
                    className={cx(className)}
                    justifyContent="space-between"
                    innerRef={setRef}
                >
                    <Text size="s">
                        {i18nBlock.partnerBonusLabel()}

                        {pointsTooltip && (
                            <TriggerDetailsButton
                                theme={EMessageBoxPopupTheme.WHITE}
                                className={cx('detailsButton')}
                                iconClassName={cx('detailsButtonIcon')}
                            >
                                <Heading level={3} size="m">
                                    {pointsTooltip.title}
                                </Heading>
                                <Box above="2" below="2" textSize="s">
                                    {pointsTooltip.text}
                                </Box>
                                {pointsTooltip.link && (
                                    <div className={cx('popupLink')}>
                                        <Link
                                            url={pointsTooltip.link.url}
                                            target="_blank"
                                            rel="noopener noreferrer"
                                        >
                                            {pointsTooltip.link.text}
                                        </Link>
                                    </div>
                                )}
                            </TriggerDetailsButton>
                        )}
                    </Text>

                    <Flex alignItems="center">
                        <LoyaltyIcon
                            className={cx('loyaltyIcon')}
                        ></LoyaltyIcon>
                        <Text size="s">{points.amount}</Text>
                    </Flex>
                </Flex>
            </ScopeContext.Provider>
        );
    };

export default WhiteLabelPartnerBonusInfo;
