import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import BookRoomDescription from './BookRoomDescription';

export default {
    title: 'Hotels/BookRoomDescription',
    component: BookRoomDescription,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const deviceType = useDeviceType();

    return (
        <BookRoomDescription
            roomInfo={{
                name: 'Двухместный номер «Премиум» с 1 двуспальной кроватью, смежные ванная комната и спальня (with Shower)',
                descriptions: {
                    overview:
                        'Стоянка для яхт, ускоренная регистрация заезда/отъезда, детская площадка, банкомат, дворецкий, удобства для людей с ограниченными возможностями, массаж, казино, консьерж, детское меню, количество баров 4',
                },
                images: [],
                amenities: [],
            }}
            deviceType={deviceType}
        />
    );
};
