import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {TStorybookFunctionComponent} from 'storybook/types';

import FiscalReceipt from './FiscalReceipt';

export default {
    title: 'Hotels/FiscalReceipt',
    component: FiscalReceipt,
    decorators: [routerDecorator],
} as Meta;

const url = 'https://s3.mds.yandex.net/sandbox-469/1967162860/receipt.pdf';

export const Simple: TStorybookFunctionComponent = () => (
    <FiscalReceipt fiscalReceiptUrl={url} />
);

Simple.parameters = {
    info: {
        title: 'Ссылка на чек',
    },
};
