import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useBoolean} from 'utilities/hooks/useBoolean';

import * as i18nBlock from 'i18n/hotels-FiscalReceipt';

import LinkButton from 'components/LinkButton/LinkButton';
import EmptyFiscalTooltip from './components/EmptyFiscalTooltip/EmptyFiscalTooltip';
import FiscalReceiptModal from 'projects/hotels/components/FiscalReceipt/components/FiscalReceiptModal/FiscalReceiptModal';

import cx from './FiscalReceipt.scss';

interface IFiscalReceiptProps extends IWithClassName, IWithQaAttributes {
    canRenderTooltipForEmptyUrl?: boolean;
    triggerText?: string;
    fiscalReceiptUrl: string | undefined;
}

const FiscalReceipt: React.FC<IFiscalReceiptProps> = props => {
    const {
        className,
        triggerText = '',
        fiscalReceiptUrl,
        canRenderTooltipForEmptyUrl = false,
    } = props;

    const {
        value: isVisible,
        setFalse: closeModal,
        setTrue: openModal,
    } = useBoolean(false);

    if (fiscalReceiptUrl) {
        return (
            <>
                <LinkButton
                    className={cx('trigger', className)}
                    theme="normal"
                    onClick={openModal}
                >
                    {triggerText || i18nBlock.fiscalReceiptTitle()}
                </LinkButton>
                <FiscalReceiptModal
                    fiscalReceiptUrl={fiscalReceiptUrl}
                    isVisible={isVisible}
                    onClose={closeModal}
                    {...prepareQaAttributes(props)}
                />
            </>
        );
    }

    if (canRenderTooltipForEmptyUrl) {
        return (
            <EmptyFiscalTooltip
                triggerText={triggerText}
                triggerClassName={className}
            />
        );
    }

    return (
        <h5 className={cx('title', className)}>
            {i18nBlock.emptyFiscalReceiptTitle()}
        </h5>
    );
};

export default React.memo(FiscalReceipt);
