import React, {useRef, useState} from 'react';

import * as i18nBlock from 'i18n/hotels-FiscalReceipt';

import MessageBoxPopup from 'components/MessageBoxPopup/MessageBoxPopup';

import cx from './EmptyFiscalTooltip.scss';

interface IEmptyFiscalTooltipProps {
    triggerText: string;
    triggerClassName?: string;
}

const EmptyFiscalTooltip: React.FC<IEmptyFiscalTooltipProps> = props => {
    const {triggerText, triggerClassName} = props;
    const [canRenderTooltip, setTooltipView] = useState(false);
    const triggerRef = useRef(null);

    return (
        <>
            <span
                className={cx('trigger', triggerClassName)}
                onClick={(): void => setTooltipView(true)}
                ref={triggerRef}
            >
                {triggerText}
            </span>
            <MessageBoxPopup
                anchorRef={triggerRef}
                isVisible={canRenderTooltip}
                onClose={(): void => setTooltipView(false)}
            >
                <div className={cx('tooltip')}>
                    {i18nBlock.emptyFiscalReceiptTitle()}
                </div>
            </MessageBoxPopup>
        </>
    );
};

export default React.memo(EmptyFiscalTooltip);
