import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useBoolean} from 'utilities/hooks/useBoolean';

import FiscalReceiptModal from './FiscalReceiptModal';

export default {
    title: 'Hotels/FiscalReceiptModal',
    component: FiscalReceiptModal,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const {value, setTrue, setFalse} = useBoolean(false);

    return (
        <>
            <button onClick={setTrue}>open</button>
            <FiscalReceiptModal
                isVisible={value}
                onClose={setFalse}
                fiscalReceiptUrl="https://s3.mds.yandex.net/sandbox-469/1967162860/receipt.pdf"
            />
        </>
    );
};

Simple.parameters = {
    info: {
        title: 'Модальное окно с чеком',
    },
};
