import React, {useMemo} from 'react';
import ReactIFrame from 'react-iframe';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import ModalWithBackButton from 'components/ModalWithBackButton/ModalWithBackButton';
import Modal, {EModalAnimationType} from 'components/Modal/Modal';

import cx from './FiscalReceiptModal.scss';

interface IFiscalReceiptModalProps extends IWithQaAttributes {
    fiscalReceiptUrl: string;
    isVisible: boolean;
    backButtonText?: string;
    onClose(): void;
}

const FiscalReceiptModal: React.FC<IFiscalReceiptModalProps> = props => {
    const {fiscalReceiptUrl, backButtonText, isVisible, onClose} = props;
    const deviceType = useDeviceType();

    const content = useMemo(() => {
        return (
            <Modal.Content
                className={cx('modalContent')}
                {...(deviceType.isMobile
                    ? {
                          inset: 0,
                      }
                    : {})}
            >
                <ReactIFrame
                    url={fiscalReceiptUrl}
                    className={cx('iframeInstance')}
                />
            </Modal.Content>
        );
    }, [deviceType.isMobile, fiscalReceiptUrl]);

    const rootCx = cx('root', deviceMods('root', deviceType));

    if (deviceType.isMobile) {
        return (
            <ModalWithBackButton
                className={rootCx}
                isVisible={isVisible}
                onClose={onClose}
                backButtonText={backButtonText}
                fullScreen
                animation={EModalAnimationType.PUSH_RIGHT}
                canRenderBackButton
                verticalAlign="stretch"
                {...prepareQaAttributes(props)}
            >
                {content}
            </ModalWithBackButton>
        );
    }

    return (
        <Modal
            className={rootCx}
            isVisible={isVisible}
            onClose={onClose}
            {...prepareQaAttributes(props)}
        >
            {content}
        </Modal>
    );
};

export default React.memo(FiscalReceiptModal);
