import {FunctionComponent, useCallback, useMemo} from 'react';

import {YANDEX_PLUS_URL} from 'constants/urls/plus';

import {IWithClassName} from 'types/withClassName';
import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {reachGoal} from 'utilities/metrika';

import * as i18nBlock from 'i18n/hotels-ForceLogin';

import Link from 'components/Link/Link';
import ForceLoginAuthLink, {
    IForceLoginAuthLinkProps,
} from 'components/ForceLogin/ForceLoginAuthLink/ForceLoginAuthLink';

interface IForceLoginNotAuthUserProps extends IWithClassName {
    isBookPage?: boolean;
    isSearchPage?: boolean;
}

const ForceLoginNotAuthUser: FunctionComponent<IForceLoginNotAuthUserProps> = ({
    className,
    isBookPage,
    isSearchPage,
}) => {
    const handleClick = useCallback(() => {
        if (isSearchPage) {
            reachGoal(EHotelsGoal.HOTELS_SEARCH_LOGINPLATE);
        }
    }, [isSearchPage]);

    const {message, icon} = useMemo((): {
        message: IForceLoginAuthLinkProps['message'];
        icon: IForceLoginAuthLinkProps['image'];
    } => {
        if (isBookPage) {
            const text = insertJSXIntoKey(i18nBlock.loginAndGetCashback)({
                plusLink: (
                    <Link target="_blank" url={YANDEX_PLUS_URL}>
                        {i18nBlock.plus()}
                    </Link>
                ),
            });

            return {message: text, icon: 'plus'};
        }

        return {message: i18nBlock.logInAndGetOffersForYou(), icon: 'yandex'};
    }, [isBookPage]);

    return (
        <ForceLoginAuthLink
            className={className}
            image={icon}
            message={message}
            dropShadow={isBookPage}
            onClick={handleClick}
        />
    );
};

export default ForceLoginNotAuthUser;
