import {ICardProps} from 'components/Card/Card';

const oldCardProps: ICardProps = {
    shadow: 'default',
    radius: 'm',
};

const newCardProps: ICardProps = {
    shadow: 'none',
    radius: 'm',
};

const shadowOverride: ICardProps = {
    shadow: 'default',
};

interface IGetCommonCardPropsParams {
    isMobile: boolean;
    dropShadow?: boolean;
}

export default function getCommonCardProps({
    isMobile,
    dropShadow,
}: IGetCommonCardPropsParams): ICardProps {
    const shadow = dropShadow && isMobile ? shadowOverride : {};

    const props = isMobile ? newCardProps : oldCardProps;

    return {...props, ...shadow};
}
