import React from 'react';

import {IBookOfferPrice} from 'server/api/HotelsBookAPI/types/IBookOffer';
import {
    EHotelBadgeType,
    IHotelOrOfferBadge,
} from 'types/hotels/offer/IHotelOffer';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-GoToForm';
import * as i18nMirCashbackBlock from 'i18n/mirCashback';

import CommonGoToForm from 'components/GoToForm/GoToForm';
import Button from 'components/Button/Button';
import Flex from 'components/Flex/Flex';
import HotelOfferBadge from 'projects/hotels/components/HotelOfferBadge/HotelOfferBadge';

interface IGoToFormProps extends IWithQaAttributes {
    active: boolean;
    onButtonClick: React.MouseEventHandler<HTMLButtonElement>;
    getBorderTopToHidden: () => number | undefined;
    mirCashbackIsEligible: boolean;
    price: IBookOfferPrice;
}

const mirBadge: IHotelOrOfferBadge = {
    id: EHotelBadgeType.MIR_CASHBACK,
    text: i18nMirCashbackBlock.cashbackPercentages(),
};

const GoToForm: React.FC<IGoToFormProps> = props => {
    const {onButtonClick, getBorderTopToHidden, active, mirCashbackIsEligible} =
        props;

    return (
        <CommonGoToForm
            getBorderTopToHidden={getBorderTopToHidden}
            active={active}
            {...prepareQaAttributes(props)}
        >
            <Flex
                inline
                justifyContent="space-between"
                alignItems="center"
                between={mirCashbackIsEligible ? 2 : 0}
                nowrap
            >
                <Flex flexDirection="column">
                    {mirCashbackIsEligible && (
                        <HotelOfferBadge badge={mirBadge} />
                    )}
                </Flex>

                <Button
                    type="button"
                    theme="primary"
                    onClick={onButtonClick}
                    size="l"
                    width="max"
                >
                    {i18nBlock.buttonText()}
                </Button>
            </Flex>
        </CommonGoToForm>
    );
};

export default GoToForm;
