import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import HotelAddress from './HotelAddress';

export default {
    title: 'Hotels/HotelAddress',
    component: HotelAddress,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <HotelAddress text="Россия, Москва, улица Щипок, 22, стр. 1" />
);

export const Link: TStorybookFunctionComponent = () => (
    <HotelAddress type="link" text="Россия, Москва, улица Щипок, 22, стр. 1" />
);

export const SeparateLink: TStorybookFunctionComponent = () => (
    <HotelAddress
        type="separate-link"
        text="Россия, Москва, улица Щипок, 22, стр. 1"
    />
);
export const SingleLine: TStorybookFunctionComponent = () => (
    <HotelAddress
        type="link"
        text="Россия, Москва, улица Щипок, 22, стр. 1, Россия, Москва, улица Щипок, 22, стр. 1, Россия, Москва, улица Щипок, 22, стр. 1, Россия, Москва, улица Щипок, 22, стр. 1, Россия, Москва, улица Щипок, 22, стр. 1"
    />
);

export const MultiLine: TStorybookFunctionComponent = () => (
    <HotelAddress
        multiLine
        type="link"
        text="Россия, Москва, улица Щипок, 22, стр. 1, Россия, Москва, улица Щипок, 22, стр. 1, Россия, Москва, улица Щипок, 22, стр. 1, Россия, Москва, улица Щипок, 22, стр. 1, Россия, Москва, улица Щипок, 22, стр. 1"
    />
);
