import {FC} from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {CHAR_SPACE} from 'utilities/strings/charCodes';

import * as i18nBlockPage from 'i18n/hotels-HotelPage';

import LinkButton from 'components/LinkButton/LinkButton';

import cx from './SeparateLink.scss';

interface ISeparateLinkProps {
    text: string;
    onClick: () => void;
}

const SeparateLink: FC<ISeparateLinkProps> = ({text, onClick}) => {
    const deviceType = useDeviceType();

    return (
        <>
            <span className={cx('address', deviceMods('address', deviceType))}>
                {text}
            </span>
            {CHAR_SPACE}
            <LinkButton onClick={onClick} className={cx('link')}>
                {i18nBlockPage.viewLocation()}
            </LinkButton>
        </>
    );
};

export default SeparateLink;
