import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import HotelAddressAndRating from './HotelAddressAndRating';

export default {
    title: 'Hotels/HotelAddressAndRating',
    component: HotelAddressAndRating,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const deviceType = useDeviceType();

    return (
        <HotelAddressAndRating
            // @ts-ignore
            hotelInfo={{
                rating: 4.2,
                address: 'Россия, Москва, улица Щипок, 22, стр. 1',
            }}
            deviceType={deviceType}
        />
    );
};

export const Link: TStorybookFunctionComponent = () => {
    const deviceType = useDeviceType();

    return (
        <HotelAddressAndRating
            // @ts-ignore
            hotelInfo={{
                rating: 4.2,
                address: 'Россия, Москва, улица Щипок, 22, стр. 1',
            }}
            addressType="link"
            deviceType={deviceType}
        />
    );
};

export const LongAddress: TStorybookFunctionComponent = () => {
    const deviceType = useDeviceType();

    return (
        <HotelAddressAndRating
            addressType="link"
            // @ts-ignore
            hotelInfo={{
                rating: 4.2,
                address:
                    'Россия, Москва, улица Щипок, 22, стр. 1, Россия, Москва, улица Щипок, 22, стр. 1, Россия, Москва, улица Щипок, 22, стр. 1, Россия, Москва, улица Щипок, 22, стр. 1',
            }}
            deviceType={deviceType}
        />
    );
};
