import {FunctionComponent} from 'react';

import {IWithClassName} from 'src/types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';
import {IBookHotelInfo} from 'server/api/HotelsBookAPI/types/IBookOffer';

import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import HotelAddress, {
    IHotelAddressProps,
} from 'projects/hotels/components/HotelAddress/HotelAddress';
import Rating from 'components/Rating/Rating';

import cx from './HotelAddressAndRating.scss';

export interface IHotelAddressAndRatingProps
    extends IWithClassName,
        IWithDeviceType,
        IWithQaAttributes {
    hotelInfo: IBookHotelInfo;
    addressType: IHotelAddressProps['type'];
    onAddressClick: IHotelAddressProps['onClick'];
    multiLine?: boolean;
}

const HotelAddressAndRating: FunctionComponent<IHotelAddressAndRatingProps> =
    props => {
        const {
            className,
            addressType,
            onAddressClick,
            hotelInfo: {rating, address},
            deviceType,
        } = props;

        const multiline = props.multiLine ?? deviceType.isMobile;

        return (
            <div
                className={cx(
                    'addressAndRating',
                    deviceMods('addressAndRating', deviceType),
                    className,
                )}
                {...prepareQaAttributes(props)}
            >
                {Boolean(rating) && (
                    <Rating size="m" className={cx('rating')} rating={rating} />
                )}
                <HotelAddress
                    className={cx('address')}
                    onClick={onAddressClick}
                    text={address}
                    type={addressType}
                    multiLine={multiline}
                />
            </div>
        );
    };

export default HotelAddressAndRating;
