import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nRebranding from 'i18n/index-Advantages';

import Advantages, {TAdvantage} from 'components/Advantages/Advantages';
import useTitle from 'components/Advantages/hooks/useTitle';
import PlusCashback3DImage from 'icons/raster-illustrations/M/PlusCashback3D';
import ManyHotels3DImage from 'icons/raster-illustrations/M/ManyHotels3D';
import Reviews3DImage from 'icons/raster-illustrations/M/Reviews3D';
import Support3DImage from 'icons/raster-illustrations/M/Support3D';

interface IHotelAdvantages extends IWithClassName, IWithQaAttributes {}

const HotelAdvantages: React.FC<IHotelAdvantages> = props => {
    const {className} = props;

    const title = useTitle(i18nRebranding.hotelsTitle);

    const advantages = useMemo((): TAdvantage[] => {
        const iconWidth = 220;
        const iconHeight = 180;

        return [
            {
                description: i18nRebranding.hotelsBestPriceDescription(),
                IconComponent: PlusCashback3DImage,
                iconWidth,
                iconHeight,
            },
            {
                description: i18nRebranding.hotelsBestVariantDescription(),
                IconComponent: ManyHotels3DImage,
                iconWidth,
                iconHeight,
            },
            {
                description: i18nRebranding.hotelsReviewsDescription(),
                IconComponent: Reviews3DImage,
                iconWidth,
                iconHeight,
            },
            {
                description: i18nRebranding.commonSupportDescription(),
                IconComponent: Support3DImage,
                iconWidth,
                iconHeight,
            },
        ];
    }, []);

    return (
        <Advantages
            className={className}
            title={title}
            advantages={advantages}
            {...prepareQaAttributes(props)}
        />
    );
};

export default React.memo(HotelAdvantages);
