import {MIN_PERCENT_TO_SHOW} from 'projects/hotels/constants/discount';

import {IDiscountInfo} from 'types/hotels/offer/IHotelOffer';

import {CHAR_EN_DASH} from 'utilities/strings/charCodes';

import StriketroughText from 'components/StriketroughText/StriketroughText';
import Price from 'components/Price/Price';
import Text, {TTextSize} from 'components/Text/Text';

import cx from './DiscountInfo.scss';

interface IDiscountInfoProps {
    isMobile?: boolean;
    discountInfo: IDiscountInfo;
    hotelsPercentDiscount?: boolean;
    striketroughTextClassName?: string;
    priceClassName?: string;
    percentSize?: TTextSize;
    discountSize?: TTextSize;
}

const DiscountInfo: React.FC<IDiscountInfoProps> = ({
    discountInfo,
    hotelsPercentDiscount,
    percentSize,
    discountSize = 'm',
    striketroughTextClassName,
    priceClassName,
}) => {
    const showPercentage =
        hotelsPercentDiscount &&
        discountInfo.percent &&
        discountInfo.percent >= MIN_PERCENT_TO_SHOW;

    return (
        <div>
            <StriketroughText
                size={discountSize}
                crossed
                theme={showPercentage ? 'secondary' : 'alert'}
                className={striketroughTextClassName}
            >
                <Price
                    className={priceClassName}
                    {...discountInfo.strikethroughPrice}
                    color="secondary"
                />
            </StriketroughText>
            {showPercentage && (
                <Text
                    className={cx('percent')}
                    color="alert"
                    size={percentSize}
                >
                    {`${CHAR_EN_DASH}${discountInfo.percent}%`}
                </Text>
            )}
        </div>
    );
};

export default DiscountInfo;
