import React, {useCallback, useMemo} from 'react';

import {TResponsiveImage} from 'types/common/TImage';

import LazyComponent from 'components/LazyComponent/LazyComponent';
import ImagesSwipeCarousel from 'components/ImagesSwipeCarousel/ImagesSwipeCarousel';

import cx from './ImagesCarousel.scss';

interface IImagesCarouselProps {
    images: TResponsiveImage[];
    isLazy: boolean;
    onScrollContent(): void;
    onImageClick(): void;
}

const ImagesCarousel: React.FC<IImagesCarouselProps> = props => {
    const {images, isLazy, onScrollContent, onImageClick} = props;

    const renderPlaceholder = useCallback(
        ref => <div className={cx('placeholder')} ref={ref} />,
        [],
    );

    const renderContent = useCallback(() => {
        return (
            <ImagesSwipeCarousel
                borderRadius="m"
                borderWidth="s"
                images={images}
                onImageClick={onImageClick}
                onScrollContent={onScrollContent}
                className={cx('carousel')}
                swipeableClassName={cx('carouselContent')}
            />
        );
    }, [images, onImageClick, onScrollContent]);

    const options = useMemo(
        () => ({
            rootMargin: '500px',
            triggerOnce: true,
            skip: !isLazy,
        }),
        [isLazy],
    );

    if (!isLazy) {
        return renderContent();
    }

    return (
        <LazyComponent
            intersectionObserverOptions={options}
            renderPlaceholder={renderPlaceholder}
            renderContent={renderContent}
        />
    );
};

export default React.memo(ImagesCarousel);
