import React, {FunctionComponent, useMemo} from 'react';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {convertHotelOrRoomImages} from 'projects/hotels/utilities/prepareAndParseImages/prepareAndParseImages';

import * as i18nBlock from 'i18n/hotels-HotelPageRooms';

import Link from 'components/Link/Link';
import ImagesCarousel from 'components/ImagesCarousel/ImagesCarousel';
import HotelInfoSearchCard from 'projects/hotels/components/HotelInfoSearchCard/HotelInfoSearchCard';

import HotelMinPriceOffer from '../HotelMinPriceOffer/HotelMinPriceOffer';
import {ICommonHotelCardWithMinPriceProps} from '../../HotelCardWithMinPrice';

import cx from './HotelCardWithMinPriceMobile.scss';

const HOTEL_IMAGE_SIZE_NAME = 'M';
/** Значение должно быть синхронизировано с $slider_image_height в .scss файле */
const IMAGES_CAROUSEL_HEIGHT = 150;

const HotelCardWithMinPriceMobile: FunctionComponent<ICommonHotelCardWithMinPriceProps> =
    props => {
        const {
            className,
            cardUsagePage,
            hotelInfoClassName,
            hotelWithMinPrice,
            hotelUrl,
            linkTarget,
            hotelReviewsUrl,
            region,
            onClick,
        } = props;
        const {hotel, minPrice, nights, badges, hasOfferYandexPlus} =
            hotelWithMinPrice;
        const {permalink, images} = hotel;

        const preparedImages = useMemo(() => {
            const convertedImages = convertHotelOrRoomImages(
                images,
                HOTEL_IMAGE_SIZE_NAME,
            );

            return convertedImages.map(image => ({
                ...image,
                alt: i18nBlock.hotelImageAlt({
                    category: hotel.category.name,
                    hotelName: hotel.name,
                    preposition: region.linguistics.preposition,
                    cityPrepositionalCase: region.linguistics.prepositionalCase,
                }),
            }));
        }, [images, hotel, region]);

        return (
            <section
                key={permalink}
                className={cx('hotelCard', className)}
                onClick={onClick}
                {...prepareQaAttributes(props)}
            >
                {preparedImages.length > 0 && (
                    <ImagesCarousel
                        className={cx('slider')}
                        imageClassName={cx('slideImage')}
                        images={preparedImages}
                        isDesktop={false}
                        height={IMAGES_CAROUSEL_HEIGHT}
                        lazyLoad
                        isLoadImageOnViewportIntersect
                    />
                )}
                <div className={cx('content', hotelInfoClassName)}>
                    <Link
                        url={hotelUrl}
                        className={cx('hotelLink')}
                        target={linkTarget || '_self'}
                        rel="noopener noreferrer"
                    />
                    <HotelInfoSearchCard
                        className={cx('hotelInfo')}
                        hotel={hotel}
                        hotelUrl={hotelUrl}
                        hotelReviewsUrl={hotelReviewsUrl}
                        cardUsagePage={cardUsagePage}
                    />
                    <HotelMinPriceOffer
                        className={cx('priceInfo')}
                        minPrice={minPrice}
                        hotelUrl={hotelUrl}
                        nights={nights}
                        badges={badges}
                        hasOfferYandexPlus={hasOfferYandexPlus}
                        linkTarget={linkTarget}
                        regionSlug={region.slug}
                        {...prepareQaAttributes(props)}
                    />
                </div>
            </section>
        );
    };

export default React.memo(HotelCardWithMinPriceMobile);
