import {TExperiments} from 'server/providers/experiments/types';

import * as i18nStaticBlock from 'i18n/hotels-seoPage-plusInfo';

const regionsWithMorePlusPoints = [
    'makhachkala',
    'gorno-altaysk',
    'elista',
    'petrozavodsk',
    'syktyvkar',
    'salekhard',
    'arhangelsk',
    'kazan',
    'grozniy',
    'izhevsk',
    'yakutsk',
    'cherkessk',
    'cheboksary',
    'krasnoyarsk',
    'khabarovsk',
    'komsomolsk-at-amur',
    'nizhnekamsk',
    'severodvinsk',
    'republic-of-karelia',
    'republic-of-dagestan',
    'republic-of-tatarstan',
    'republic-of-kalmykia',
    'altai-republic',
    'udmurt-republic',
    'chuvash-republic',
    'khabarovsk-krai',
    'arkhange-lskaya-oblast',
];

export default function getPlusBadgeButtonText(
    experiments: TExperiments,
    regionSlug?: string,
): string {
    return regionSlug &&
        !experiments.hideMorePlusPointsOnRegionPage &&
        regionsWithMorePlusPoints.includes(regionSlug)
        ? i18nStaticBlock.isAvailableThirtyPercentBadge()
        : i18nStaticBlock.isAvailableTenPercentBadge();
}
