import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IHotelGeoFeature} from 'types/hotels/hotel/IHotel';

import {getGeoFeatureIconComponent} from 'projects/hotels/components/HotelGeoFeature/utilities/getGeoFeatureIconComponent';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import TextWithIcon, {TSize} from 'components/TextWithIcon/TextWithIcon';

interface IHotelGeoFeaturesProps extends IWithClassName, IWithQaAttributes {
    geoFeature?: IHotelGeoFeature | null;
    size?: TSize;
    isMobile?: boolean;
}

const HotelGeoFeature: React.FC<IHotelGeoFeaturesProps> = props => {
    const {className, geoFeature, size, isMobile} = props;

    return geoFeature ? (
        <TextWithIcon
            className={className}
            text={geoFeature.name}
            iconLeft={getGeoFeatureIconComponent(geoFeature.icon, isMobile)}
            spaceBetween={1}
            size={size}
            {...prepareQaAttributes(props)}
        />
    ) : null;
};

export default HotelGeoFeature;
