import React from 'react';

import {IWithClassName} from 'types/withClassName';

import * as i18nBlock from 'i18n/hotels-Geodistance';

import GeolocationIcon from 'icons/12/Geolocation';
import GeolocationOutlineIcon from 'icons/16/GeolocationOutline';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

interface IHotelGeodistance extends IWithClassName {
    distanceText?: string;
    isMobile?: boolean;
}

const HotelGeodistance: React.FC<IHotelGeodistance> = props => {
    const {className, distanceText, isMobile} = props;

    const icon = isMobile ? GeolocationOutlineIcon : GeolocationIcon;

    if (!distanceText) {
        return null;
    }

    return (
        <TextWithIcon
            className={className}
            iconLeft={icon}
            text={i18nBlock.distanceText({distanceText})}
            spaceBetween={1}
            size={isMobile ? 'm' : 's'}
        />
    );
};

export default React.memo(HotelGeodistance);
