import React, {ReactNode} from 'react';

import {CHAR_DASH, CHAR_NBSP, CHAR_SPACE} from 'utilities/strings/charCodes';

import cx from './HotelName.scss';

interface IHotelNameProps {
    hotelName: string;
    icon?: ReactNode;
}

const HotelName: React.FC<IHotelNameProps> = ({hotelName, icon}) => {
    const hotelNameParts = hotelName
        .split(CHAR_SPACE)
        .map(part => part.split(CHAR_DASH));

    const hasParts = hotelNameParts.length > 1;
    const hasTailParts =
        hasParts && hotelNameParts[hotelNameParts.length - 1].length > 1;
    const hotelNameTail = hasTailParts
        ? hotelNameParts[hotelNameParts.length - 1].pop()
        : hotelNameParts.pop();

    const hotelNameHead = hotelNameParts
        .map(parts => parts.join(CHAR_DASH))
        .join(CHAR_SPACE);

    return (
        <>
            {hotelNameHead}
            {Array.isArray(hotelNameTail) ? CHAR_SPACE : CHAR_DASH}
            <span className={cx('hotelNameNoWrapPart')}>
                {Array.isArray(hotelNameTail)
                    ? hotelNameTail.join(CHAR_DASH)
                    : hotelNameTail}
                {CHAR_NBSP}
                {icon}
            </span>
        </>
    );
};

export default HotelName;
