import {EHotelBadgeType, TBadgeType} from 'types/hotels/offer/IHotelOffer';

import {ELabelThemeType} from 'components/Label/Label';

export default function getLabelTheme(
    id: TBadgeType,
): ELabelThemeType | undefined {
    switch (id) {
        case EHotelBadgeType.HOTEL_ADS:
            return ELabelThemeType.NORMAL;
        case EHotelBadgeType.TAXI_PROMOCODE:
        case EHotelBadgeType.WELCOME_PROMOCODE:
            return ELabelThemeType.NEUTRAL;
        default:
            return undefined;
    }
}
