import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/hotels-HotelOfferBigBadge';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import hotelDirectLogo from 'projects/hotels/components/HotelOfferBanner/components/DirectBanner/images/hotelDirectLogo.svg';

import cx from './DirectBanner.scss';

interface IDirectBannerProps extends IWithClassName, IWithQaAttributes {
    hotelName: string | undefined;
}

const DirectBanner: React.FC<IDirectBannerProps> = props => {
    const {className, hotelName = ''} = props;

    const deviceType = useDeviceType();

    return (
        <Flex
            className={cx('root', className)}
            alignItems="flex-start"
            {...prepareQaAttributes(props)}
        >
            <div className={cx('icon')}>
                <img src={hotelDirectLogo} alt={i18nBlock.hotelDirectText()} />
            </div>

            <section>
                <Text
                    className={cx('text')}
                    tag="p"
                    color="inverse"
                    size={deviceType.isMobile ? 'm' : 'l'}
                    weight={deviceType.isMobile ? 'bold' : 'medium'}
                >
                    {i18nBlock.hotelDirectText()}
                </Text>

                <Text
                    className={cx('comment')}
                    tag="p"
                    size={deviceType.isMobile ? 's' : 'm'}
                >
                    {i18nBlock.hotelDirectComment({hotelName})}
                </Text>
            </section>
        </Flex>
    );
};

export default React.memo(DirectBanner);
