import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/hotels-HotelRating';

import Rating from 'components/Rating/Rating';

/* Init Styles */
import cx from './HotelRatingWithLabel.scss';

interface IHotelRatingWithLabelProps extends IWithClassName {
    rating: number | null;
}

const getHotelTextRating = (rating: number): string => {
    switch (true) {
        case rating >= 4: {
            return i18nBlock.great();
        }

        case rating >= 3: {
            return i18nBlock.fine();
        }

        case rating >= 1: {
            return i18nBlock.good();
        }

        default: {
            return i18nBlock.none();
        }
    }
};

const HotelRatingWithLabel: FunctionComponent<IHotelRatingWithLabelProps> = ({
    rating,
}) => {
    const {isMobile} = useDeviceType();

    if (rating) {
        return (
            <div className={cx('ratingWithLabel')}>
                <Rating rating={rating} size={isMobile ? 'm' : 'l'} />
                <div className={cx('label', {label_mobile: isMobile})}>
                    {getHotelTextRating(rating)}
                </div>
            </div>
        );
    }

    return null;
};

export default HotelRatingWithLabel;
