import {FC} from 'react';

import {IWithClassName} from 'types/withClassName';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-Common';

import Rating from 'components/Rating/Rating';
import LinkButton from 'components/LinkButton/LinkButton';

import cx from './HotelRatingWithReviewLink.scss';

interface IHotelRatingWithLabelProps extends IWithClassName {
    rating: number | null;
    isMobile: boolean;
    onTotalReviewLinkClick?: () => void;
    totalTextReviewCount: number;
}

const HotelRatingWithReviewLink: FC<IHotelRatingWithLabelProps> = props => {
    const {
        rating,
        isMobile,
        onTotalReviewLinkClick,
        totalTextReviewCount,
        className,
    } = props;

    if (!rating) {
        return null;
    }

    return (
        <div
            className={cx('root', className)}
            {...prepareQaAttributes('rating')}
        >
            <div className={cx('inner')} onClick={onTotalReviewLinkClick}>
                <Rating rating={rating} size={isMobile ? 'm' : 'l'} />
                <div className={cx('label', {label_mobile: isMobile})}>
                    {totalTextReviewCount > 0 && (
                        <LinkButton
                            className={cx('totalReviewCount')}
                            {...prepareQaAttributes('reviewsLink')}
                        >
                            {i18nBlock.totalReviewCount({
                                totalReviewCount: totalTextReviewCount,
                            })}
                        </LinkButton>
                    )}
                </div>
            </div>
        </div>
    );
};

export default HotelRatingWithReviewLink;
