import {FunctionComponent, MouseEvent, useCallback} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IKeyPhrase} from 'types/hotels/hotel/IHotelTextReview';

import {CHAR_MIDDLE_DOT, CHAR_NBSP} from 'utilities/strings/charCodes';
import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import CheckButton from 'components/CheckButton/CheckButton';

import cx from './KeyPhraseCheckButton.scss';

export interface IKeyPhraseCheckButtonProps
    extends IWithClassName,
        IWithQaAttributes {
    keyPhrase: IKeyPhrase;
    checked: boolean;
    onClick: (keyPhrase: string, element: HTMLElement) => void;
}

const KeyPhraseCheckButton: FunctionComponent<IKeyPhraseCheckButtonProps> = ({
    keyPhrase,
    checked,
    onClick,
    className,
    ...rest
}) => {
    const {name, reviewCount} = keyPhrase;
    const keyPhraseText = `${name}${CHAR_NBSP}${CHAR_MIDDLE_DOT}${CHAR_NBSP}${reviewCount}`;

    const handleOnClick = useCallback(
        (e: MouseEvent<HTMLElement>) => {
            onClick(keyPhrase.name, e.currentTarget);
        },
        [keyPhrase, onClick],
    );

    return (
        <CheckButton
            className={cx('keyPhrase', className)}
            checked={checked}
            size="m"
            onClick={handleOnClick}
            {...rest}
        >
            {keyPhraseText}
        </CheckButton>
    );
};

export default KeyPhraseCheckButton;
