import {useCallback, FunctionComponent} from 'react';

import {UserReactionType} from 'types/hotels/hotel/IHotelTextReview';
import {IHotelReviewReactionPayload} from 'reducers/hotels/hotelPage/reviews/list/types';

/* Components */
import TextReviewLikes from '../TextReviewLikes/TextReviewLikes';
import TextHotelReview, {ITextHotelReviewProps} from './TextHotelReview';

/* Component Types */
interface IHotelReviewWithReactionProps
    extends Omit<ITextHotelReviewProps, 'controls'> {
    isAuth: boolean;
    onHotelReviewReaction: (reaction: IHotelReviewReactionPayload) => void;
}

const HotelReviewWithReaction: FunctionComponent<IHotelReviewWithReactionProps> =
    props => {
        const {isAuth, onHotelReviewReaction, review, ...restProps} = props;
        const {id, userReaction, totalDislikeCount, totalLikeCount} = review;

        const handleUserReactionClick = useCallback(
            (reaction: UserReactionType) => {
                onHotelReviewReaction({
                    reviewId: id,
                    userReaction: reaction,
                    previousUserReaction: userReaction,
                });
            },
            [id, userReaction, onHotelReviewReaction],
        );

        return (
            <TextHotelReview
                review={review}
                bottomControls={
                    <TextReviewLikes
                        isAuth={isAuth}
                        userReaction={userReaction}
                        totalLikeCount={totalLikeCount}
                        totalDislikeCount={totalDislikeCount}
                        onUserReactionClick={handleUserReactionClick}
                    />
                }
                {...restProps}
            />
        );
    };

export default HotelReviewWithReaction;
