import React, {useCallback, useState} from 'react';

import {IHotelOrRoomImage} from 'types/hotels/hotel/IHotelImages';
import {IWithClassName} from 'types/withClassName';
import {EHotelImageAltayStandardSize} from 'types/hotels/common/EHotelImageAltayStandardSize';

import {parseAltaiImageUrlTemplate} from 'projects/hotels/utilities/prepareAndParseImages/prepareAndParseImages';

import HotelPageImagesViewer from 'projects/hotels/pages/HotelPage/components/HotelPageImagesViewer/HotelPageImagesViewer';

import TextReviewGallery from '../TextReviewGallery/TextReviewGallery';

interface ITextReviewImagesProps extends IWithClassName {
    images: IHotelOrRoomImage[];
}

const TextReviewImages: React.FC<ITextReviewImagesProps> = ({
    className,
    images,
}) => {
    const [selectedImageIndex, setSelectedImageIndex] = useState<number>();
    const handleImagesModalClose = useCallback(
        () => setSelectedImageIndex(undefined),
        [setSelectedImageIndex],
    );

    const imageUrls = images.map(({urlTemplate, sizes}) =>
        parseAltaiImageUrlTemplate(
            urlTemplate,
            EHotelImageAltayStandardSize.S,
            sizes,
        ),
    );

    return (
        <>
            <TextReviewGallery
                className={className}
                imageUrls={imageUrls}
                onImageClick={setSelectedImageIndex}
            />
            <HotelPageImagesViewer
                isVisible={selectedImageIndex !== undefined}
                totalImageCount={images.length}
                initialIndex={selectedImageIndex}
                images={images}
                onCloseClick={handleImagesModalClose}
                imageSrcGetter={parseAltaiImageUrlTemplate}
            />
        </>
    );
};

export default TextReviewImages;
