import React, {useCallback, useEffect, useMemo, useState} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {IAddHotelReviewRequest} from 'server/api/HotelSearchAPI/types/IAddHotelReview';
import {TImagesSelectorImage} from 'components/ImagesSelector/types/IImagesSelectorImage';

import {addHotelReviewActions} from 'reducers/hotels/hotelPage/reviews/add/actions';

import addHotelReview from 'selectors/hotels/hotel/reviewsTab/addHotelReview';

import ReviewDialog, {IReviewDialogValues} from '../ReviewDialog/ReviewDialog';

interface ICreateReviewDialogProps {
    isVisible: boolean;
    stars: number;
    onClose: () => void;
    onSuccess: () => void;
    onError: (payload: IAddHotelReviewRequest) => void;
}

const CreateReviewDialog: React.FC<ICreateReviewDialogProps> = ({
    isVisible,
    stars,
    onClose,
    onSuccess,
    onError,
}) => {
    const {isSubmitting, isSuccess, hasError} = useSelector(addHotelReview);
    const [submittedValues, setSubmittedValues] =
        useState<IAddHotelReviewRequest>({
            reviewRating: stars,
        });
    const dispatch = useDispatch();
    const addReview = useCallback(
        ({reviewImages, ...restValue}: IReviewDialogValues) => {
            const payload = {
                reviewImageIds: reviewImages.map(({id}) => id),
                ...restValue,
            };

            setSubmittedValues(payload);
            dispatch(addHotelReviewActions.request(payload));
        },
        [dispatch],
    );
    const initialValues = useMemo(
        () => ({
            reviewRating: stars,
            reviewText: '',
            reviewImages: [] as TImagesSelectorImage[],
        }),
        [stars],
    );

    useEffect(() => {
        if (isSuccess) {
            onSuccess();
        }
    }, [isSuccess, onSuccess]);

    useEffect(() => {
        if (hasError && isVisible) {
            onClose();
            onError(submittedValues);
        }
    }, [hasError, submittedValues, isVisible, onClose, onError]);

    return (
        <ReviewDialog
            isVisible={isVisible}
            isSubmitting={isSubmitting}
            onClose={onClose}
            onSubmit={addReview}
            initialValues={initialValues}
        />
    );
};

export default CreateReviewDialog;
