import * as i18nBlock from 'i18n/common-validation';
import * as i18nHotelReviewsBlock from 'i18n/hotels-HotelReviews';

const MAX_LENGTH = 1000;

interface IOptions {
    prohibitEmpty?: boolean;
}

export function validateReviewText({
    prohibitEmpty,
}: IOptions): (value?: string) => string {
    return (value?: string): string => {
        if (value && value.length > MAX_LENGTH) {
            return i18nBlock.maxLength({count: MAX_LENGTH});
        }

        if (prohibitEmpty && !value) {
            return i18nHotelReviewsBlock.emptyCommentValidationError();
        }

        return '';
    };
}
