import * as localStorage from 'local-storage';

const STORED_STARS_KEY = 'yandexTravel/hotels_selected_review_stars';

export function storeSelectedStars(stars: number): void {
    localStorage.set(STORED_STARS_KEY, stars.toString());
}

export function restoreSelectedStars(): number | undefined {
    const value = localStorage.get(STORED_STARS_KEY);

    if (value) {
        return Number(value);
    }

    return undefined;
}

export function clearSelectedStars(): void {
    localStorage.remove(STORED_STARS_KEY);
}
