import React from 'react';

import {EProjectName} from 'constants/common';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';
import {EFooterProject} from 'components/Footer/types';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import LayoutDefault from 'components/Layouts/LayoutDefault/LayoutDefault';

import {usePlatform} from 'contexts/PlatformContext';

import cx from './HotelsBookLayout.scss';

export interface IHotelsBookLayoutProps
    extends IWithClassName,
        IWithDeviceType,
        IWithQaAttributes {
    children: React.ReactNode;
    hasLoader: boolean;
}

const HotelsBookLayout: React.FC<IHotelsBookLayoutProps> = props => {
    const {
        className,
        hasLoader,
        children,
        deviceType: {isDesktop, isIe},
    } = props;
    const {isWeb} = usePlatform();

    return (
        <LayoutDefault
            className={cx(
                {hotelsBookLayout_hasIELoader: isIe && hasLoader},
                className,
            )}
            project={EProjectName.HOTELS}
            footerType={EFooterProject.HOTELS_BOOKING}
            showNavigation={isDesktop}
            showFooter={isWeb}
            showHeader={isWeb}
            {...prepareQaAttributes(props)}
        >
            {children}
        </LayoutDefault>
    );
};

export default HotelsBookLayout;
