import React, {useRef} from 'react';

import {IWithClassName} from 'types/withClassName';

import getDirectId, {PlaceType} from './lib/getDirectId';
import {useMobile} from 'utilities/hooks/useMobile';
import {useDidUpdateEffect} from 'utilities/hooks/useDidUpdateEffect';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import {Direct} from 'components/Direct/Direct';

export interface IHotelsDirectProps extends IWithClassName, IWithQaAttributes {
    place: PlaceType;
    /**
     * При изменении этого параметра, обновляется реклама
     */
    updater?: string | number | boolean;
}

const HotelsDirect: React.FC<IHotelsDirectProps> = props => {
    const {place, className, updater} = props;

    const directRef = useRef<Direct>(null);

    const isMobile = useMobile();
    const directId = getDirectId(place, isMobile);

    useDidUpdateEffect(() => {
        const {current} = directRef;

        if (current) {
            current.update();
        }
    }, [updater]);

    if (!directId) {
        return null;
    }

    return (
        <Direct
            className={className}
            blockId={directId}
            isMobile={isMobile}
            ref={directRef}
            updateTimeoutInSecond={10}
            {...prepareQaAttributes(props)}
        />
    );
};

export default HotelsDirect;
