import {Platform} from 'types/Platform';

import getPlatform from 'utilities/deviceType/getPlatform';

export type PlaceType = 'search' | 'hotelPageMain' | 'hotelPageFooter';

const dict: {
    [place in PlaceType]: {
        [platform in Platform]?: string;
    };
} = {
    search: {
        [Platform.DESKTOP]: 'R-I-272158-21',
        [Platform.TOUCH]: 'R-I-539137-2',
    },
    hotelPageMain: {
        [Platform.DESKTOP]: 'R-I-272158-20',
    },
    hotelPageFooter: {
        [Platform.DESKTOP]: 'R-I-272158-19',
        [Platform.TOUCH]: 'R-I-539137-4',
    },
};

export default function getDirectId(place: PlaceType, isMobile: boolean) {
    const platform = getPlatform(isMobile);

    return dict[place][platform];
}
