import {ReactNode, FC} from 'react';

import {IDevice} from 'reducers/common/commonReducerTypes';

import {deviceMods} from 'utilities/stylesUtils';

import Flex from 'components/Flex/Flex';
import HorizontalScroller from 'components/HorizontalScroller/HorizontalScroller';

export interface IHotelsFiltersBarProps {
    className?: string;
    deviceInfo: IDevice;
    beforeFiltersNode?: ReactNode;
    quickFiltersNode?: ReactNode;
    toggleFiltersVisibilityNode?: ReactNode;
}

/* Init Styles*/
import cx from './HotelsFiltersBar.scss';

const HotelsFiltersBar: FC<IHotelsFiltersBarProps> = props => {
    const {
        deviceInfo,
        className,
        beforeFiltersNode,
        toggleFiltersVisibilityNode,
        quickFiltersNode,
    } = props;

    if (deviceInfo.isMobile) {
        return (
            <HorizontalScroller scrollableClassName={cx('scrollable')}>
                <Flex
                    className={cx(
                        'filtersBar',
                        'filtersBar_redesign',
                        deviceMods('filtersBar', deviceInfo),
                        className,
                    )}
                    between={deviceInfo.isDesktop ? 5 : 2}
                    flexWrap="nowrap"
                    inline
                >
                    {toggleFiltersVisibilityNode}
                    {quickFiltersNode}
                </Flex>
            </HorizontalScroller>
        );
    }

    return (
        <Flex
            className={cx(
                'filtersBar',
                deviceMods('filtersBar', deviceInfo),
                className,
            )}
            between={deviceInfo.isDesktop ? 5 : 2}
            flexWrap="nowrap"
            inline
        >
            {beforeFiltersNode}
            {quickFiltersNode}
            {toggleFiltersVisibilityNode}
        </Flex>
    );
};

export default HotelsFiltersBar;
