import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useWhiteLabelConfig} from 'utilities/hooks/useWhiteLabelConfig';

import cx from './HotelsFiltersBarSkeleton.scss';

export interface IHotelsFiltersBarSkeleton extends IWithClassName {}

const HotelsFiltersBarSkeleton: React.FC<IHotelsFiltersBarSkeleton> = props => {
    const {isWhiteLabel} = useWhiteLabelConfig();

    return (
        <div className={cx('filtersBar', props.className)}>
            <div className={cx('quickFilters')}>
                {!isWhiteLabel && <div className={cx('quickButton')} />}
                <div className={cx('quickButton')} />
                <div className={cx('quickButton')} />
            </div>
            <div className={cx('toggleButton')} />
        </div>
    );
};

export default HotelsFiltersBarSkeleton;
