import _isNumber from 'lodash/isNumber';

/* Types */
import {IDevice} from 'reducers/common/commonReducerTypes';

import {deviceMods} from 'utilities/stylesUtils';
import getButtonText from './utilities/getButtonText';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-SearchPageFilters';

/* Components */
import Button from 'components/Button/Button';
import Box from 'components/Box/Box';

import cx from './HotelsFiltersControlButtons.scss';

/* Component Types */
interface IHotelsFiltersControlButtonsProps extends IWithQaAttributes {
    className?: string;
    foundHotelCount?: number;
    isDisabledResetButton: boolean;
    deviceInfo: IDevice;
    onResetFilters: () => void;
    onApplyFilters: () => void;
}

const HotelsFiltersControlButtonsWithBox: React.FC<IHotelsFiltersControlButtonsProps> =
    (props: IHotelsFiltersControlButtonsProps) => {
        const {
            className,
            onResetFilters,
            onApplyFilters,
            foundHotelCount,
            deviceInfo,
            isDisabledResetButton,
        } = props;

        const {isMobile} = deviceInfo;
        const buttonWidth = isMobile ? 'max' : 'auto';

        return (
            <Box
                className={cx(
                    'root',
                    deviceMods('root', deviceInfo),
                    className,
                )}
                inline
                between={2}
                nowrap={isMobile}
            >
                <Button
                    onClick={onResetFilters}
                    size="l"
                    theme="attention"
                    width={buttonWidth}
                    disabled={isDisabledResetButton}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'resetFilters',
                    })}
                >
                    {isMobile ? i18nBlock.reset() : i18nBlock.resetAll()}
                </Button>
                {_isNumber(foundHotelCount) && (
                    <Button
                        className={cx('button_apply')}
                        onClick={onApplyFilters}
                        size="l"
                        width={buttonWidth}
                        theme="primary"
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'applyFilters',
                        })}
                    >
                        {getButtonText(foundHotelCount, isMobile)}
                    </Button>
                )}
            </Box>
        );
    };

export default HotelsFiltersControlButtonsWithBox;
